/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.util.model;

import com.tp_link.eap.domain.eap.bean.ApMonitorInfo;
import com.tp_link.eap.domain.mesh.pojo.DfsChannelTime;
import com.tp_link.eap.domain.mesh.pojo.DfsChannelTimeConf;
import com.tp_link.eap.rmi.LaunchInfoBean$InfoType;
import com.tp_link.eap.util.a.b;
import com.tp_link.eap.util.f;
import com.tp_link.eap.util.l;
import com.tp_link.eap.util.model.IncompatibleModel;
import com.tp_link.eap.util.model.IncompatibleModelConf;
import com.tp_link.eap.util.model.ModelVersionMap;
import com.tp_link.eap.util.model.ModelVersionMapConf;
import java.io.InputStream;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelCache {
    private static final Logger logger = LoggerFactory.getLogger(ModelCache.class);
    private static ModelVersionMapConf modelVerMapConf = null;
    private static IncompatibleModelConf incompatibleModelConf = null;
    private static DfsChannelTimeConf dfsChannelTimeConf = null;

    public static int loadModelVersionMap() {
        try {
            InputStream inputStream = ModelCache.class.getResourceAsStream("/json/model_version_map.json");
            modelVerMapConf = (ModelVersionMapConf)b.a(inputStream, ModelVersionMapConf.class);
        }
        catch (Exception exception) {
            logger.error(exception.toString(), (Throwable)exception);
            f.a(LaunchInfoBean$InfoType.ERROR, "Load model version map failed.");
            return -1;
        }
        return 0;
    }

    public static int loadIncompatibleModels() {
        try {
            InputStream inputStream = ModelCache.class.getResourceAsStream("/json/incompatibleModels.json");
            incompatibleModelConf = (IncompatibleModelConf)b.a(inputStream, IncompatibleModelConf.class);
        }
        catch (Exception exception) {
            logger.error(exception.toString(), (Throwable)exception);
            return -1;
        }
        return 0;
    }

    public static boolean pickupVersions(String fwversion, String[] strVers) {
        if (strVers.length != 3) {
            logger.error("params not right! strVers! = {}", (Object)Arrays.toString(strVers));
            return false;
        }
        String[] stringArray = fwversion.split(" ");
        if (stringArray.length == 0) {
            logger.warn("params not right! strVers!");
            return false;
        }
        String string = stringArray[0];
        String[] stringArray2 = string.split("\\.");
        if (stringArray2.length != 3) {
            logger.warn("firmware ver split not equal 3");
            return false;
        }
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            strVers[i2] = stringArray2[i2];
        }
        return true;
    }

    public static String checkAndGetModelVersion(String modelName, String fwVersion) {
        ModelVersionMap modelVersionMap = null;
        if (null == modelName || null == fwVersion) {
            logger.error("null params!");
            return null;
        }
        if (null == modelVerMapConf) {
            logger.error("Not load the model map json file!");
            return null;
        }
        for (int i2 = 0; i2 < modelVerMapConf.getModelMapArrayList().size(); ++i2) {
            modelVersionMap = modelVerMapConf.getModelMapArrayList().get(i2);
            if (!modelVersionMap.getModelName().equals(modelName) || !fwVersion.matches(modelVersionMap.getFwVersionRegex())) continue;
            return modelVersionMap.getModelVersion();
        }
        logger.warn("Walk through all the regex, and no matches.");
        return null;
    }

    public static boolean firmwareCompatible(ApMonitorInfo ami) {
        if (ami.getDeviceMisc() != null && ami.getDeviceMisc().getCustomizeRegion() == null) {
            return false;
        }
        return ModelCache.firmwareCompatible(ami.getModel(), ami.getModelVersion(), ami.getVersion());
    }

    public static boolean firmwareCompatible(String model, String modelVersion, String fwVer) {
        if (fwVer == null || model == null) {
            logger.warn("input is null");
            return false;
        }
        if (modelVersion == null) {
            modelVersion = ModelCache.checkAndGetModelVersion(model, fwVer);
            if (modelVersion == null) {
                logger.warn("modelVersion of {} {} is null", (Object)model, (Object)fwVer);
                return false;
            }
            logger.debug("modelVersion is {}", (Object)modelVersion);
        }
        try {
            int n = l.a(fwVer);
            if (n < 0) {
                logger.warn("Invalid fwVersion {}", (Object)fwVer);
                return false;
            }
            if (null != incompatibleModelConf) {
                for (IncompatibleModel incompatibleModel : incompatibleModelConf.getIncompatibleModels()) {
                    if (!incompatibleModel.getModelName().equals(model) || !incompatibleModel.getModelVersion().equals(modelVersion) || n < incompatibleModel.getFwVersionMin() || n >= incompatibleModel.getFwVersionMax()) continue;
                    return false;
                }
            }
        }
        catch (Exception exception) {
            logger.warn(exception.toString(), (Throwable)exception);
            return false;
        }
        return true;
    }

    public static int loadMeshDfsModels() {
        try {
            String string = "/json/meshDfsModels.json";
            InputStream inputStream = ModelCache.class.getResourceAsStream(string);
            dfsChannelTimeConf = (DfsChannelTimeConf)b.a(inputStream, DfsChannelTimeConf.class);
        }
        catch (Exception exception) {
            logger.error(exception.toString(), (Throwable)exception);
            return -1;
        }
        return 0;
    }

    public static int getMeshMeshDfs(int channel) {
        if (channel <= 0) {
            logger.warn("input is null");
            return -1;
        }
        if (null != dfsChannelTimeConf) {
            for (DfsChannelTime dfsChannelTime : dfsChannelTimeConf.getDfsChannelTimes()) {
                if (dfsChannelTime.getChannel() != channel) continue;
                return dfsChannelTime.getTimeout();
            }
        }
        return -1;
    }
}

